#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <algorithm>
#include <map>
#include <set>
#include <vector>
#include <cmath>
#include <cstring>
#include <queue>
#include <deque>

#define mp make_pair
#define mt(a, b, c) mp(a, mp(b, c))
#define ABS(a) ((a > 0) ? (a) : (-a))
#define ZERO(x) memset((x), 0, sizeof(x))
#define X first
#define Y second

using namespace std;
typedef long long ll;
typedef unsigned long long ull;

ll gcd(ll a, ll b)
{
	if (b == 0)
		return a;
	return gcd(b, a % b);
}

struct fraction
{
	ll p, q;
	fraction()
	{
		p = 0, q = 1;
	}
	fraction(ll _p, ll _q)
	{
		p = _p, q = _q;
	}
	fraction(ll _p)
	{
		p = _p, q = 1;
	}
};

fraction operator +(fraction A, fraction B)
{
	fraction res = fraction(A.p * B.q + A.q * B.p, A.q * B.q);
	ll g = gcd(ABS(res.p), ABS(res.q));
	res.p /= g;
	res.q /= g;
	return res;
}

fraction operator *(fraction A, fraction B)
{
	fraction res = fraction(A.p * B.p, A.q * B.q);
	ll g = gcd(ABS(res.p), ABS(res.q));
	res.p /= g;
	res.q /= g;
	return res;
}


int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);

	string dir;

	while (true)
	{
		cin >> dir;
		if (dir == "#")
		{
			break;
		}

		int i = 0;
		ll st2 = 1;
		fraction ans;
		int p = dir.size() - 1;
		bool first = true;
		while (p >= 0)
		{
			if (dir[p] == 'h')
			{
				p -= 5;
				if (first)
				{
					ans = 0;
					first = false;
				}
				else
				{
					ans = ans + fraction(-90, st2);
				}
			}
			else if (dir[p] == 't')
			{			
				p -= 4;
				if (first)
				{
					ans = 90;
					first = false;
				}
				else
				{
					ans = ans + fraction(90, st2);
				}				
			}
			else
			{
				cout << dir[p] << endl;
			}
			st2 *= 2;
		}
		cout << ans.p;
		if (ans.q != 1)
		{
			cout << "/" << ans.q;
		}
		cout << endl;
	}


	return 0;
}